#!/usr/bin/awk -f
# /etc/racoon/racoon.conf
BEGIN{RS = "\r\n|\n"}
# comments
/^\s*#/ {print; next}
# space
/^\s*$/ {print; next}
# content by gws
/^\s*}\s*$/ {print; next}
/^\s*authentication_(algorithm|method) [a-z0-9_]+;\s*$/ {print; next}
/^\s*compression_algorithm deflate;\s*$/ {print; next}
/^\s*dh_group [0-9]+;\s*$/ {print; next}
/^\s*dpd_(delay|maxfail|retry) [0-9]+;\s*$/ {print; next}
/^\s*encryption_algorithm [a-z0-9 ,]+;\s*$/ {print; next}
/^\s*exchange_mode main;\s*$/ {print; next}
/^\s*generate_policy on;\s*$/ {print; next}
/^\s*hash_algorithm [a-z0-9]+;\s*$/ {print; next}
/^\s*initial_contact (on|off);\s*$/ {print; next}
/^\s*lifetime time [0-9]+ sec;\s*$/ {print; next}
/^\s*log (debug2?|error|info|notify|warning);\s*$/ {print; next}
/^\s*my_identifier address;\s*$/ {print; next}
/^\s*nat_traversal on;\s*$/ {print; next}
/^\s*passive (on|off);\s*$/ {print; next}
/^\s*path pre_shared_key "\/etc\/racoon\/psk\.txt";\s*$/ {print; next}
/^\s*peers_identifier address( [0-9.]+)?;\s*$/ {print; next}
/^\s*pfs_group [0-9]+;\s*$/ {print; next}
/^\s*ph1id [0-9]+;\s*$/ {print; next}
/^\s*proposal \{\s*$/ {print; next}
/^\s*proposal_check (obey|strict);\s*$/ {print; next}
/^\s*remote [0-9.]+ \{\s*$/ {print; next}
/^\s*remote anonymous \{\s*$/ {print; next}
/^\s*remoteid [0-9]+;\s*$/ {print; next}
/^\s*sainfo address [0-9.\/]+ any address [0-9.\/]+ any \{\s*$/ {print; next}
/^\s*sainfo anonymous \{\s*$/ {print; next}
/^\s*script "\/etc\/racoon\/phase1_(l2tp|tun)" phase1_(dead|down|up);\s*$/ {print; next}
/^\s*verify_identifier (off|on);\s*$/ {print; next}
# other
#{print > "/dev/stderr"}

