#!/bin/sh
###############################################################################
#                                                                             #
#                            Update system files                              #
#                                                                             #
# - $1 location of this script                                                #
# - $2 log file location                                                      #
#                                                                             #
###############################################################################
U_LOG=$2
E_LOG=$3
if [ "$U_LOG" = "" ]; then
    U_LOG=/tmp/res.txt
fi
if [ "$E_LOG" = "" ]; then
    E_LOG=/tmp/err.txt
fi
export UPD_ROOT=$1
export ERR_LOG=$E_LOG
export BACKUP_DIR=/root/upd/backup/


logg()
{
    echo -e "$(date) - $1" | tee -a $UPD_LOG
}



DIRNAME="busybox dirname"
AWK="busybox awk"
TR="busybox tr"
CUT="busybox cut"
SED="busybox sed"
SHA512SUM="busybox sha512sum"



###############################################################################
#                                                                             #
#                                The Script                                   #
#                                                                             #
###############################################################################


# locate GWUPD directory
GWUPD_DIR=$($DIRNAME $U_LOG)
DONE_DIR=$(cd $($DIRNAME $U_LOG); cd ..; echo $(pwd))

DONE_FILE="$DONE_DIR/done"

#SUM_CMD=md5sum
SUM_CMD=$SHA512SUM


heading()
{
    echo -e "\n##\n#\t$1\n#" >> $DEBUG
}



IsUpdateDone()
{
    grep -sq $1 $DONE_FILE && return 0

    return 2
}

UPD_HASH=$(cat $GWUPD_DIR/md5sums | grep "upd." | $AWK '{print $1}')

MAC_ADDR=$(cat /sys/class/net/eth0/address)
DONE_STRING=$(echo "$UPD_HASH-$MAC_ADDR" | $SUM_CMD | $AWK '{print $1}')

SD_CARD=/mnt/sd

DEBUG_DIR="$SD_CARD/$(echo "$MAC_ADDR" | $SED s/://g | $CUT -b5-12)/"

DEBUG=$DEBUG_DIR/INFO

if [ -e /dev/mmcblk0p1 ]; then
    mkdir -p $DEBUG_DIR
    export UPD_LOG=$DEBUG_DIR/res.txt
else
    export UPD_LOG=$U_LOG
fi

echo "Log continues in file: $UPD_LOG" >> $U_LOG

logg "Checking if update is applied."

# rm -f /usr/bin/prototype

IsUpdateDone $DONE_STRING
if [ "$?" != "0" ]; then
# update not done

    if [ -d ${GWUPD_DIR}_done ]; then
        logg "Removing old update folder."
        rm -rf ${GWUPD_DIR}_done
    fi

    logg "Starting update to $(cat $UPD_ROOT/VERSION), $(cat $UPD_ROOT/PACKED)"


    if [ -e /dev/mmcblk0p1 ]; then

        logg "Writing info to SD-card"

        heading "MAC address"
        echo $MAC_ADDR >> $DEBUG

        heading "Current time"
        date >> $DEBUG

        heading "Disk free space"
        df -h >> $DEBUG

        heading "Network interfaces"
        ifconfig >> $DEBUG

        heading "Memory info"
        cat /proc/meminfo >> $DEBUG

        heading "List of currently running processes"
        ps aux >> $DEBUG

        # list of setup files to backup
# 		logg "Writing Setup to SD-card"
# 		cp /root/gw5Setup.bin $DEBUG_DIR/
# 		cp /root/log.conf.xml $DEBUG_DIR/

        logg "Syncing filesystem"
        sync
    fi

    logg "Starting UpdateSystem.sh"
    $UPD_ROOT/UpdateSystem.sh
    #if [ "$?" = "0" ]; then
    logg "Writing done '$DONE_STRING' to '$DONE_FILE'"
    echo $DONE_STRING >> $DONE_FILE
    #fi

    chmod a+r $UPD_LOG

    logg "Update script finished."

    if [ "$GWUPD_DIR" != "/mnt/sd/gwupd" ]; then
        mv $GWUPD_DIR ${GWUPD_DIR}_done
        chmod a+r ${GWUPD_DIR}_done/*
        rm -f ${GWUPD_DIR}_done/upd.*
    fi

    sync

    if [ -e /dev/mmcblk0p1 ]; then
        umount -l $SD_CARD
    fi

    # if CPU is PXA270, reboot system
    grep Hardware /proc/cpuinfo | grep PXA270 > /dev/null && reboot
    
else
    logg "Update is already applied."

    if [ "$GWUPD_DIR" != "/mnt/sd/gwupd" ]; then
        mv $GWUPD_DIR ${GWUPD_DIR}_done
        chmod a+r ${GWUPD_DIR}_done/*
    fi

    if [ -e /dev/mmcblk0p1 ]; then
        umount -l $SD_CARD
    fi
fi
